unit mBidoku;

interface
uses Sysutils, mAusgabe;
const stoppZahl=256;

type TBidoku = class
  private
    merkZeile, merkSpalte, merkKasten : array[0..1,0..15] of Integer;
         //Anzahl Nullen - Einsen
    F, Loesung : array[0..255] of char;
    kAusgabe : TfrmAusgabe;
    function kastenNr (j : integer) : integer;
    procedure testen(n, test : integer; var Anzahl:integer);
    procedure loesen(n : integer; var Anzahl:integer);
    procedure AllesMerken;
  public
    constructor create(pAus:TfrmAusgabe);
    function Loese:integer;
    procedure ZahlSchreiben (wohin: integer; was : string);
    function ZahlLesen (welche : integer) : char;
    procedure speichern2Memo;
end;

implementation

constructor TBidoku.create(pAus:TfrmAusgabe);
var i : integer;
begin
  kAusgabe := pAus;
  for i := 0 to 255 do F[i] :=' ';
end;

function TBidoku.Loese:integer;
var anzahl : integer;
begin
  AllesMerken;
  anzahl :=0;
  loesen(0,anzahl);
  if anzahl > 0 then F := Loesung;
  Loese := anzahl;
end;

procedure TBidoku.AllesMerken;
var i : integer;
begin
  for i := 0 to 15 do begin
   merkZeile[0,i] := 0;   merkZeile[1,i] := 0;
   merkSpalte[0,i] := 0;  merkSpalte[1,i] := 0;
   merkKasten[0,i] := 0;  merkKasten[1,i] := 0;
 end;
 for i := 0 to 255 do begin
   if F[i] ='1' then begin
     merkZeile[1,i div 16] := merkZeile[1,i div 16] + 1;
     merkSpalte[1,i mod 16] := merkSpalte[1,i mod 16] + 1;
     merkKasten[1,kastenNr(i)] := merkKasten[1,kastenNr(i)] + 1;
   end;
   if F[i] ='0' then begin
     merkZeile[0,i div 16] := merkZeile[0,i div 16] + 1;
     merkSpalte[0,i mod 16] := merkSpalte[0,i mod 16] + 1;
     merkKasten[0,kastenNr(i)] := merkKasten[0,kastenNr(i)] + 1;
   end;
   end; // for
end;

procedure TBidoku.loesen(n : integer; var anzahl:integer);
begin
  if (n<stoppzahl) then begin
    if F[n] <> ' ' then loesen(n+1, anzahl) // vorgegebene Zahl --> weiter
    else begin
      testen (n, 0, anzahl);
      if anzahl < 2 then testen (n, 1, anzahl);
    end;
  end else begin Loesung := F; inc(anzahl);speichern2Memo end;
end;

procedure TBidoku.testen(n, test : integer; var Anzahl:integer);
begin
  if (merkZeile[test,n div 16]<8) and
     (merkSpalte[test,n mod 16]<8) and
     (merkKasten[test,kastenNr(n)]<8)
  then begin                   // setzen
     inc(merkZeile[test,n div 16]);
     inc(merkSpalte[test,n mod 16]);
     inc(merkKasten[test,kastenNr(n)]);
     F[n] := chr(48+test);
     loesen(n+1, Anzahl);   // rekursiver Aufruf
     if Anzahl <2 then begin // Backtracking zurueck
        dec(merkZeile[test,n div 16]);
        dec(merkSpalte[test,n mod 16]);
        dec(merkKasten[test,kastenNr(n)]);
        F[n] := ' ';
     end;
  end;
end;

function TBidoku.kastenNr (j : integer) : integer;
begin
  kastenNr := 4 * (j div 64) + (j mod 16) div 4
end;

procedure TBidoku.ZahlSchreiben (wohin: integer; was : string);
begin F[wohin] := was[1]; end;

function TBidoku.ZahlLesen (welche : integer) : char;
begin  ZahlLesen := F[welche] end;

procedure TBidoku.speichern2Memo;
var i,j,k,l : integer; s:string;
begin


  s :='.....................'; kAusgabe.ausgeben(s);

  for l := 0 to 3 do begin
    for k := 0 to 3 do begin
      s :='.';
      for j := 0 to 3 do begin
        for i := 0 to 3 do s := s+ZahlLesen(64*l+16*k+4*j+i);
        s := s + '.';
        end;
      kAusgabe.ausgeben(s);
      end;
    s :='.....................'; kAusgabe.ausgeben(s);
    end;

end;
end.
 